library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;
use work.cpu_lib.all;
--use work.cpu_math.all;

entity mem is
  port (addr : in bit16;
        sel, rw : in std_logic;
        ready : out std_logic;
        data : inout bit16);
end mem;

architecture behave of mem is
begin
  memproc: process(addr, sel, rw)
    type t_mem is array(0 to 34) of bit16;
    variable mem_data : t_mem := 
     ("0010000000000000",  --- 0  loadI 0, #
      "0000000000010110",  --- 1  25
      "0010000000000001",  --- 2  loadI 1, #
      "0000000000010111",  --- 3  26
      "0000100000000010",  --- 4  load 0, 2
      "0000100000100111",  --- 5  load 1, 3
      "0011000000001011",  --- 6  bgtI 2, 3, #
      "0000000000001100",  --- 7  12
      "0011100000000000",  --- 8  inc 0
      "0011100000000001",  --- 9  inc 1
      "0010100000000000",  --- 10 braI #
      "0000000000000100",  --- 11 04
      "0000000000000000",  --- 12 storeM 2, #
      "0000000000000000"   --- 13 24
      "0001100001000011",  --- 14 move 3, 2
      "0000000000000000",  --- 15 loadop #
      "0000000000000000",  --- 16 24
      "0001100001010100",  --- 17 moveop 3
      "0001000000110001",  --- 18 store 3, 1
      "0001000001000010",  --- 19 store 4, 2
      "0011100000000000",  --- 20 inc 0
      "0011100000000001",  --- 21 inc 1
      "0010100000000000",  --- 22 braI #
      "0000000000000100",  --- 23 04
      "0000000000000000",  --- 24
      "0000000011000000",  --- 25
      "0000000000011000",  --- 26
      "0000000001000001",  --- 27
      "0000000011100000",  --- 28
      "0000000011111000",  --- 29
      "0000000000000001",  --- 30
      "0000000000000011",  --- 31
      "0000000001100001",  --- 32
      "0000000000001100",  --- 33
      "0000000000000110",  --- 34
      "0000000000000010",  --- 35
      "0000000000000000",  --- 36
      "0000000011111111"); --- 37

  begin
    data <= "ZZZZZZZZZZZZZZZZ";
    ready <= '0';

    if sel = '1' then 
      if rw = '0' then
        data <= mem_data(CONV_INTEGER(addr(15 downto 0))) after 1 ns;
        ready <= '1';
      elsif rw = '1' then 
        mem_data(CONV_INTEGER(addr(15 downto 0))) := data;
      end if;
    else
      data <= "ZZZZZZZZZZZZZZZZ" after 1 ns;
    end if;
  end process;

end behave;


